% Pipelined ADC with code density test
clc;
clear; close all;
rand('state',123); %rand('state',sum(123*clock)); 

num_bit = 10; full_scale = 2;
num_sample = 8*2^num_bit;
a_in = linspace(-1,1,num_sample)';        % Distributing the samples linearly between min and max

Pipeline_ADC_Model;                       % Simulating the pipelined ADC

disp('    Calculating INL and DNL...');
[dnl,inl,offset] = DNL_INL(a_in,d_out,num_bit);
[mono_one,mono_two,missing_code,wide_code] = Monotonicity(d_out,dnl);    % Investigating the monotonicity
[max_dnl,res_dnl,max_inl,res_inl] = Max_DNL_INL(dnl,inl);

figure;
for j = 2:num_bit-1
    subplot(0.5*num_bit-1,2,j-1);
    plot(a_in,a_res(:,j),'r');
    s = sprintf('stage %.3g res',j-1);
    grid on; ylabel(s);
end

figure;
plot(a_in,d_out);
title('Transfer Curve');grid on;
xlabel('analog input');ylabel('digital code');

figure;
subplot(2,1,1);plot(dnl);title('DNL');grid on;
axis([0 2^num_bit-1 floor(min(dnl))-1e-3 ceil(max(dnl))+1e-3]);
ylabel('differential nonlinearity');
subplot(2,1,2);plot(inl);title('INL');grid on;
axis([0 2^num_bit-1 floor(min(inl))-1e-3 ceil(max(inl))+1e-3]);
xlabel('digital code');ylabel('integral nonlinearity');

disp([missing_code wide_code mono_one mono_two offset]);
