% 1.5-b/s Pipelined A/D behavior model;
% a_in is the analog input, d_out is the digital output, and d_code is the
% vector of weighted partial decisions from individual stages;

disp('    Simulating ADC...');
cap_sigma = (0)*ones(num_bit-2,1);     % Capacitance mismatch
cmp_sigma = (0)*ones(num_bit-1,1);     % Comparator mismatch

caps_1 = 1*ones(1,num_bit-2)+randn(1,num_bit-2).*cap_sigma';
caps_2 = ones(1,num_bit-2)+randn(1,num_bit-2).*cap_sigma';
%caps_1(1) = 1.2; caps_2(1) = 1;
caps = [caps_1; caps_2];
gains = 10^(200/20)*ones(1,num_bit-2);   % Gain of the amplifiers in different stages
offsets = 0*randn(1,num_bit-2);          % Offset of different stages
disp([caps; gains]);

a_res = zeros(num_sample,num_bit-1);
a_res(:,1) = a_in;                       % Residue of different stages
d_code = zeros(num_sample,num_bit-1);    % Digital code of different stages for different samples

scheme = 2;  % 1 for normal quantization, 2 for SRT algorithm.
for k = 1:num_bit-2
    d_code(:,k) = Quantize(a_res(:,k),1,cmp_sigma(k),scheme);                     % Quantizing the analog output of the current stage
    a_res(:,k+1) = Residue(a_res(:,k),d_code(:,k),caps(:,k),gains(k),offsets(k)); % Calculating the analog output of the next stage
%    d_code(:,k) = d_code(:,k)*2^(num_bit-1-k);  % unipolar coding
    d_code(:,k) = (d_code(:,k)-1)*2^(num_bit-1-k);  % bipolar codeing             % Calculating the digital output of the current stage according to its weighting
%    s = sprintf('    Calculating stage %d ...',k); disp(s);
end
d_code(:,num_bit-1) = Quantize(a_res(:,num_bit-1),1,cmp_sigma(num_bit-1),scheme); % Quantizing the analog output of the final stage
d_out = sum(d_code,2);                                                            % d_out is the digital output
