function d_output = Quantize(a_input,resolution,cmp_sigma,scheme)
% quantization to n-bit.

if scheme == 1  % normal quantization
   threshold = linspace(-1+2^(-resolution+1),1-2^(-resolution+1),2^resolution-1)';
   threshold = threshold+2*cmp_sigma*randn(size(threshold));
   d_output = zeros(size(a_input))+2^resolution;

   for j = 1:length(a_input)
       for i = 1:length(threshold)
           if a_input(j) < threshold(i)
              d_output(j) = i-2;
              break;
           end
       end
   end
end

if scheme == 2  % SRT quantization
   threshold = (-1+3*2^(-resolution-1):2^(-resolution):1-3*2^(-resolution-1))';
   threshold = threshold+2*cmp_sigma*randn(size(threshold));
   d_output = zeros(size(a_input))+2^(resolution+1)-2;

   for j = 1:length(a_input)
       for i = 1:length(threshold)
           if a_input(j) < threshold(i)
              d_output(j) = i-1;
              break;
           end
       end
   end
end
