function [PSD,freq,SNDR_fft] = SNDR_FFT(code,num_bit,num_sample,freq_in)
% Power spectrum density and SNDR calculation using FFT;

F = fft(code);

[Fmax,Findex] = max(abs(F));
Fp = abs(F(1:num_sample/2+1))/Fmax;
PSD = 20*log10(Fp+1e-9);
freq = (0:num_sample/2)';

% for 10-bit
signal = Fp(Findex-10:Findex+10);
% for 14-bit
%signal = Fp(Findex-17:Findex+17);

SNDR_fft = 10*log10(sum(signal.^2)/(sum(Fp.^2)-Fp(1)^2-sum(signal.^2)));
