function [co_fit,SNDR_fit] = Sine_Fit(Y,time,freq)
% Calculate signal-to-noise-ratio using sine-fitting;

X = [ones(size(time)) sin(2*pi*freq*time)];
co_fit = X\Y;

signal_power = sum((co_fit(2)*sin(2*pi*freq*time)).^2);
error_power = sum((Y-co_fit(1)-co_fit(2)*sin(2*pi*freq*time)).^2);

SNDR_fit = 10*log10(signal_power/error_power);
