% Pipelined ADC with sine-wave test
clc;
clear; close all;
rand('state',123); %rand('state',sum(123*clock)); 

num_bit = 10; full_scale = 2;
num_sample = 100*2^10; freq_in = (1+num_sample/991)*97;
time = linspace(0,1,num_sample)';
amplitude = 0.9;
a_in = amplitude*sin(2*pi*freq_in*time);  % Analog Input

Pipeline_ADC_Model;                       % Model of a Pipelined ADC

% SNDR and ENOB calculation using FFT and Curve fitting.

disp('    Calculating PSD and ENOB...');
tmp = (d_out-mean(d_out)).*kaiser(length(d_out),10);
[PSD,freq,SNDR_fft] = SNDR_FFT(tmp,num_bit,num_sample,freq_in);
[co_fit,SNDR_fit] = Sine_Fit(d_out,time,freq_in);

figure(2);
plot(freq,PSD); title('PSD'); grid on;
xlabel('Frequency');ylabel('dB');axis([freq(1) freq(end) -120 0]);

ENOB_fft = (SNDR_fft-1.76-20*log10(amplitude))/6.02;
ENOB_fit = (SNDR_fit-1.76-20*log10(amplitude))/6.02;
disp([ENOB_fft ENOB_fit]);
